/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tracking.piwik;

import com.google.common.hash.Hashing;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.UUID;
import net.ftb.data.Settings;
import net.ftb.log.Logger;
import net.ftb.tracking.piwik.PiwikUtils;

public class PiwikTracker
extends Thread {
    private final String thingToTrack;
    private final String urlFrom;
    private String extraParamaters = new String();

    public PiwikTracker(String thingToTrack, String urlFrom) {
        this.thingToTrack = thingToTrack;
        this.urlFrom = urlFrom;
        this.extraParamaters = "";
    }

    public void addExtraPair(String key, String value) {
        this.extraParamaters = this.extraParamaters + "&" + PiwikUtils.addPair(key, value);
    }

    public void newSession() {
        this.extraParamaters = this.extraParamaters + "&new_visit=1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection con = null;
        try {
            if (Settings.getSettings().getGeneratedID() == null || Settings.getSettings().getGeneratedID().isEmpty()) {
                Settings.getSettings().setGeneratedID(Hashing.md5().hashUnencodedChars(UUID.randomUUID().toString()).toString().substring(0, 16));
            }
            if (this.thingToTrack.startsWith("Launcher Start v")) {
                this.newSession();
            }
            String s = "http://stats.feed-the-beast.com/piwik.php?action_name=" + PiwikUtils.urlEncode(this.thingToTrack) + this.extraParamaters + "&url=" + PiwikUtils.urlEncode(this.urlFrom) + "&idsite=6&%20rand=" + new Random().nextInt(999999) + "&%20h=18&%20m=14&%20s=3%20&rec=1&%20apiv=1&%20cookie=%20&%20urlref=http://feed-the-beast.com%20&_id=" + Settings.getSettings().getGeneratedID() + "%20&res=" + (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() + "x" + (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() + "&_cvar={1:[\"Launcher_Version\",\"" + "1.4.3 - by greg0ree" + "\"]}&ua=" + "Java/" + PiwikUtils.urlEncode(System.getProperty("java.version")) + " (" + PiwikUtils.urlEncode(System.getProperty("os.name")) + "; " + PiwikUtils.urlEncode(System.getProperty("os.arch")) + ")" + "&";
            this.extraParamaters = "";
            con = (HttpURLConnection)new URL(s).openConnection();
            con.setRequestMethod("GET");
            int result = con.getResponseCode();
            if (result != 200) {
                Logger.logDebug("Tracker request failed. Return code: " + result);
            }
        }
        catch (MalformedURLException e) {
            Logger.logError("Malformed Tracker URL", e);
        }
        catch (HeadlessException e) {
            Logger.logError("Headless Exception from Piwik", e);
        }
        catch (IOException e) {
            Logger.logError("Error Contacting tracking server", e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }
}

